﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Fred.RecordPlayer.Domain;

namespace Fred.RecordPlayer
{
    internal class ScadWriter
    {
        double _noteAngle;
        string _output;
        string _titleOutput;

        public void Generate(IPlayable recording, bool secondSide)
        {
            double overlap = 0.2;

            if (recording.TrackCount != Constants.TrackRadius.Length)
                throw new ArgumentException("No of tracks do not match");

            _noteAngle = 2 * Math.PI / (double)recording.BeatCount;
            double inner;
            double outer;

            StringBuilder sb = new StringBuilder();

            sb.AppendFormat("\t\t// Autogenerated pins for music tracks\r\n");
            for (int track = 0; track < recording.TrackCount; track++)
            {
                inner = Constants.TrackRadius[track] - 0.5 - (track %2 == 0 ? overlap : 0);
                outer = inner + 1 + overlap;

                for (int note = 0; note < recording.BeatCount; note++)
                {
                    if (recording.HasNote(track, note))
                    {
                        sb.AppendFormat("\t\tpin({0},{1},{2},{3});\r\n", inner, outer, NoteAngleDegrees(track, note, secondSide), (secondSide ? "1" : "0"));
                    }
                }

            }
            sb.AppendLine();
            _output = sb.ToString();

            _titleOutput = String.Format("\t\ttitle(\"{0}\",{1});\r\n\r\n", recording.Title.ToUpper(), (secondSide ? "1" : "0"));

        }

        private double NoteAngleDegrees(int Track, int Note, bool secondSide)
        {
            double radius = Constants.TrackRadius[Track];
            double angle = _noteAngle * Note;

            // Add track offset
            angle -= (Constants.HeadOffset / radius);
            
            angle = angle * 180 / Math.PI;
            if (secondSide)
                angle = 360 - angle;

            return angle;

        }
        public string Output
        {
            get { return _output; }
        }

        public string TitleOutput
        {
            get { return _titleOutput; }
        }
    }
}
